<?php
	$keyfile_name = "./keys.xml";

	$keyfile_content = "";
	$response_content = "";
	
	$keyfile_content = file_get_contents($keyfile_name);
	$response_content = <<<XML
<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--Keyfile for KeyManagerRSA, Dirk Heitzmann, creativeit.eu-->
<CryptedKeys KeyHash="">
</CryptedKeys>
XML;

	$keyfile_xml = new SimpleXMLElement($keyfile_content);
	$response_xml = new SimpleXMLElement($response_content);
		
    if (hasValidCert())
    {
		$response_xml["KeyHash"] =  $keyfile_xml["KeyHash"];
		foreach ($keyfile_xml->CryptedKey as $CryptedKey) {
			if (!strpos($CryptedKey->Keyname, $_SERVER['SSL_CLIENT_S_DN_CN']) === false)
			{
				$newCryptedKey = $response_xml->addChild('CryptedKey');
				$newCryptedKey->addChild('Keyname', $CryptedKey->Keyname);
				$newCryptedKey->addChild('Key', $CryptedKey->Key);
			}
		}
	}
    else
    { $response_xml->addChild('Error', "Error: No valid certificate given"); }

    header('Content-Type: text/xml'); 
	echo $response_xml->asXML();

     /**
     * Check if the browser provided a valid SSL client certificate
     * ,returns true if so
     */
    function hasValidCert()
    {
        if (   !isset($_SERVER['SSL_CLIENT_VERIFY'])
            ||        $_SERVER['SSL_CLIENT_VERIFY'] !== 'SUCCESS'
            || !isset($_SERVER['SSL_CLIENT_I_DN']) )
        {
            return false;
        }
        if ($_SERVER['SSL_CLIENT_V_REMAIN'] <= 0) 
            return false;
        return true;
    }

?>
