﻿/*
  URL Cert Key Provider for KeePass 
  Copyright (C) 2012 Dirk Heitzmann <URLCertKeyProvider (a-t) c-wd.de>

  * URLCertKeyProviderDialog 
  * Dialog for creating new kmu-Files and ... 

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  In addition :
    Uncommercial, personnel use is free.
    For commercial use see Copyright.
    Removing of information about Copyright is prohibited.
*/
using System;
using System.Drawing;
using System.Windows.Forms;


namespace URLCertKeyProvider
{
    public partial class URLCertKeyProviderDialog : Form
    {
        public URLCertKeyProviderClass KeyProvider = null;
        public Boolean ValuesValid= false;

        public URLCertKeyProviderDialog()
        {
            InitializeComponent();
        }

        private void URLCertKeyProviderDialog_Load(object sender, EventArgs e)
        {
            tbURL.Text = KeyProvider.urlfile.url;
        }

        private void tbURL_TextChanged(object sender, EventArgs e)
        {
            KeyProvider.urlfile.url = tbURL.Text;

            btnOk.Enabled = false;
            btnOk.BackColor = Color.FromKnownColor(KnownColor.Control);
        }

        private void btnGetCertificate_Click(object sender, EventArgs e)
        {
            try
            {
                if (KeyProvider.RSASelectCertificate())
                    tbCertificate.Text = KeyProvider.DecryptRSACert.Subject;
                else
                    tbCertificate.Text = "";
            }
            catch (Exception ex)
            {
                tbCertificate.Text = "";
                tbStatus.Text = ex.Message;
            }
            finally
            {
                btnOk.Enabled = false;
                btnOk.BackColor = Color.FromKnownColor(KnownColor.Control);
            }
        }

        private void btnFetch_Click(object sender, EventArgs e)
        {
            URLCertKeyProviderProgessFrom frmProgress = new URLCertKeyProviderProgessFrom();
            try
            {
                tbStatus.Text = ""; 
                this.Cursor = Cursors.WaitCursor;
                
                frmProgress.Show();

                if (CheckValues()) {
                    frmProgress.actionText = "Creating the URLFile";
                    frmProgress.actionValue = 5;
                    if (KeyProvider.CreateURLfile()) {
                        frmProgress.actionText = "Opening the URLFile";
                        frmProgress.actionValue = 35;
                        if (KeyProvider.OpenURLfile()) {
                            frmProgress.actionText = "Getting the Key from Web";
                            frmProgress.actionValue = 70;
                            if (KeyProvider.GetKeysFromWeb()) {
                                frmProgress.actionText = "Parsing the Keys";
                                frmProgress.actionValue = 80;
                                KeyProvider.ParseKeys();
                            }
                            else
                                tbStatus.Text = "Error - Unable to fetch key.";
                        }
                        else
                            tbStatus.Text = "Error - Unable to load keyfile.";
                    }
                    else
                        tbStatus.Text = "Error - Unable to create keyfile."; 
                }
            }
            catch (Exception ex)
            {
                tbStatus.Text = ex.Message;
            }
            finally
            {
                this.Cursor = Cursors.Default;
                frmProgress.actionValue = 100;
                frmProgress.Close();
                frmProgress=null;
            }


            if (KeyProvider.statAESDecrypted)
            {
                btnOk.Enabled = true;
                btnOk.BackColor = Color.Green;
                tbStatus.Text = "";
            }
            else
            {
                btnOk.Enabled = false;
                btnOk.BackColor = Color.FromKnownColor(KnownColor.Control);
            }

        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            if (CheckValues() && KeyProvider.statAESDecrypted)
                this.Close();
            else
                tbStatus.Text = "An error occur - Please re-check the parameters and fetch again.";
            btnOk.Enabled = false;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private Boolean CheckValues()
        {
            Boolean bURLCheck = false;
            if (Uri.IsWellFormedUriString(tbURL.Text, UriKind.Absolute))
            {
                KeyProvider.urlfile.url = tbURL.Text;
                bURLCheck = true;
            } 
            else
            {
                tbStatus.Text = "Error - URL is not well formed.";
            }

            Boolean bCERTCheck = false;
            if ( (KeyProvider.DecryptRSACert != null) )
            {
                bCERTCheck = true;
            }
            else
            {
                tbStatus.Text = "Error - Check the Certificate.";
            }
            
            ValuesValid = (bURLCheck && bCERTCheck);
            return ValuesValid;
        }

    }
}
