﻿/*
  URL Cert Key Provider for KeePass 
  Copyright (C) 2012 Dirk Heitzmann <URLCertKeyProvider (a-t) c-wd.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  In addition :
    Uncommercial, personnel use is free.
    For commercial use see Copyright.
    Removing of information about Copyright is prohibited.
*/

using System;
using System.Collections.Generic;
using System.IO;
using System.Security.Permissions;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;
using System.Windows.Forms;

using KeePass.Plugins;
using KeePass.Forms;
using KeePass.Resources;
using KeePassLib.Keys;
using KeePassLib.Cryptography;
using KeePassLib.Serialization;
// for UI
using KeePass.UI;
using KeePassLib.Utility;

namespace URLCertKeyProvider
{
    public sealed class URLCertKeyProviderExt : Plugin
    {
        private IPluginHost m_host = null;
        private URLCertKeyProvider m_prov = new URLCertKeyProvider();

        public override bool Initialize(IPluginHost host)
        {
            m_host = host;
            m_host.KeyProviderPool.Add(m_prov);
            return true;
        }

        public override void Terminate()
        {
            m_host.KeyProviderPool.Remove(m_prov);
        }
		
	    public override string UpdateUrl
		{
			get { return "https://www.creativeit.eu/download/keepass-plugins/URLCertKeyProvider/keepass.version"; }
		}
    }

    public sealed class URLCertKeyProvider : KeyProvider
    {
        URLCertKeyProviderClass keyclass = new URLCertKeyProviderClass();

        public override string Name
        {
            get { return "URL Certificate Key Provider"; }
        }

        public override byte[] GetKey(KeyProviderQueryContext ctx)
        {
            try
            {
                // Open Keyfile
                keyclass.urlfile.filename = UrlUtil.StripExtension(ctx.DatabaseIOInfo.Path) + ".kmu";

                if (!ctx.CreatingNewKey)
                {   // ---- open existing key
                    keyclass.DoExisting();
                }
                else
                {   // ---- open existing key for file creation
                    keyclass.DoCreate();
                }

                if (keyclass.statAESDecrypted)
                    return keyclass.AESKey.Key;
                else
                    throw new CryptographicException("Unable to decrypt key.");

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message,"UrlCertKeyProvider ERROR",MessageBoxButtons.OK,MessageBoxIcon.Error);
                return null;
            }
        }

    }
}
